CREATE DATABASE IF NOT EXISTS cmx_mynetworkdb;
USE cmx_mynetworkdb;
-- Create table for network descriptions

DROP TABLE IF EXISTS `network`;
CREATE TABLE  `network` (
  `networkid` bigint(20) NOT NULL default '0',
  `ElementTypeID` tinyint(4) NOT NULL default '0',
  `Name` varchar(63) NOT NULL default '',
  `Detail1` varchar(255) default '',
  `Detail2` varchar(255) default '',
  `Detail3` varchar(255) default '',
  `Detail4` varchar(255) default '',
  `Detail5` varchar(255) default '',
  PRIMARY KEY  (`networkid`)
) ENGINE=MyISAM AUTO_INCREMENT=152 DEFAULT CHARSET=latin1;

-- Create table for specification of network related variable names and types

DROP TABLE IF EXISTS `networkdetailconfig`;
CREATE TABLE  `networkdetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL,
  `networkid` int(11) default NULL,
  `isSize` tinyint(1) NOT NULL,
  `isColor` tinyint(1) NOT NULL,
  `isNumeric` tinyint(1) NOT NULL,
  PRIMARY KEY  (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Create table for nodes

DROP TABLE IF EXISTS `node`;
CREATE TABLE  `node` (
  `nodeID` bigint(20) NOT NULL default '0',
  `networkid` bigint(20) default NULL,
  `AliasID` bigint(20) default '0',
  `Detail1` varchar(255) default '',
  `Detail2` varchar(255) default '',
  `Detail3` varchar(255) default '',
  `Detail4` varchar(255) default '',
  `Detail5` varchar(255) default '',
  PRIMARY KEY  (`nodeID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

-- Create table for specification of node related variable names and types

DROP TABLE IF EXISTS `nodedetailconfig`;
CREATE TABLE  `nodedetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL default '0',
  `isColor` tinyint(1) NOT NULL default '0',
  `isSize` tinyint(1) NOT NULL default '0' COMMENT 'if 1 and isNumeric=1 detail can be used as size or ring property',
  `isNumeric` tinyint(1) NOT NULL default '0',
  `networkid` int(11) NOT NULL,
  PRIMARY KEY  (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED;

-- Create table for link events - i.e. all those events which link actors, e.g. sending messages, being affiliated, co-location, co-citation, citation, similarity

DROP TABLE IF EXISTS `linkevent`;
CREATE TABLE  `linkevent` (
  `linkeventID` bigint(20) NOT NULL default '0',
  `networkid` bigint(20) default NULL,
  `LinkeventDate` datetime default NULL,
  `Subject` text,
  `Content` text,
  `Detail1` varchar(255) default '',
  `Detail2` varchar(255) default '',
  `Detail3` varchar(255) default '',
  `Detail4` varchar(255) default '',
  `Detail5` varchar(255) default '',
  PRIMARY KEY  (`linkeventID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

-- Create table for specification of linkevent related variable names and types

DROP TABLE IF EXISTS `linkeventdetailconfig`;
CREATE TABLE  `linkeventdetailconfig` (
  `detail` int(10) unsigned NOT NULL,
  `label` varchar(45) NOT NULL,
  `description` varchar(45) NOT NULL,
  `isReadOnly` tinyint(1) NOT NULL,
  `networkid` int(11) default NULL,
  `isSize` tinyint(1) NOT NULL,
  `isColor` tinyint(1) NOT NULL,
  `isNumeric` tinyint(1) NOT NULL,
  PRIMARY KEY  (`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- Create table for storing the initiator/sender of linkevents (e.g. the sender of a message, the citing actor). Note, that this table can be left empty in affiliation networks, there are only receivers (e.g. meeting participation is modelled by link events with recipients only)

DROP TABLE IF EXISTS `linkeventsender`;
CREATE TABLE  `linkeventsender` (
  `linkeventID` bigint(20) NOT NULL default '0',
  `senderNodeID` bigint(20) NOT NULL default '0',
  `networkid` bigint(20) default NULL,
  PRIMARY KEY  (`linkeventID`,`senderNodeID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Create table for storing recipients of linkevents (e.g. recipients of messages, recipients of citations). If no recipient is specified, the linkevent will be treated as initiated but not referencing. Alternatively to recipients there can be parent linkevents stated, to which the linkevent links to (e.g. in discussion board structures).

DROP TABLE IF EXISTS `linkeventrecipient`;
CREATE TABLE  `linkeventrecipient` (
  `linkeventID` bigint(20) NOT NULL default '0',
  `recipientNodeID` bigint(20) NOT NULL default '0',
  `networkID` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`linkeventID`,`recipientNodeID`),
  KEY `DiscourseID` USING BTREE (`networkID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Create table for referenced parent events (e.g. if a message references another message, or article 1 referencing article 2. Can be ignored if linkeventsender and linkeventrecipient are used to specify root and sink of linkevents)

DROP TABLE IF EXISTS `linkeventparent`;
CREATE TABLE  `linkeventparent` (
  `linkeventID` bigint(20) NOT NULL default '0',
  `parentLinkeventID` bigint(20) NOT NULL default '0',
  `networkid` bigint(20) default NULL,
  PRIMARY KEY  (`linkeventID`,`parentLinkeventID`),
  KEY `DiscourseID` (`networkid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



